package com.yd.csf.api.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.yd.csf.api.dto.PolicyExcelDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@Slf4j
public class PolicyDataListener extends AnalysisEventListener<PolicyExcelDTO> {

    private List<PolicyExcelDTO> list = new ArrayList<>();

    @Override
    public void invoke(PolicyExcelDTO policy, AnalysisContext context) {
        // 校验保单数据是否完整
        if (policy.getPolicyNo() == null) {
            log.warn("第 {} 行数据校验失败，保单数据不完整", context.readRowHolder().getRowIndex());
            return;
        }

        list.add(policy);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("读取到 {} 条保单数据", list.size());
        // 这里可以调用Service进行数据保存
    }

    public List<PolicyExcelDTO> getList() {
        return list;
    }
}
