package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 出账记录表
 *
 * @TableName fortune_account
 */
@TableName(value = "fortune_account")
@Data
public class FortuneAccount implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 出账记录业务id
     */
    private String fortuneAccountBizId;

    /**
     * 转介人
     */
    private String broker;

    /**
     * 所属团队
     */
    private String team;

    /**
     * 出账币种
     */
    private String currency;

    /**
     * 出账总额
     */
    private BigDecimal amount;

    /**
     * 出账状态 可出账、待出账、已出账
     */
    private String status;

    /**
     * 出账日期
     */
    private Date fortuneAccountDate;

    /**
     * 出账信息
     */
    private String content;

    /**
     * 出账数据列表
     */
    @TableField(exist = false)
    private List<Fortune> fortuneList;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableLogic
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}