package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 规则条件配置表
 * </p>
 *
 * @author zxm
 * @since 2025-10-16
 */
@Getter
@Setter
@TableName("rule_condition_config")
public class RuleConditionConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 条件配置唯一业务ID
     */
    @TableField("condition_biz_id")
    private String conditionBizId;

    /**
     * 类型（1-条件 2-计算公式）
     */
    @TableField("type")
    private String type;

    /**
     * 一级分类编码
     */
    @TableField("first_category_code")
    private String firstCategoryCode;

    /**
     * 一级分类名称
     */
    @TableField("first_category_name")
    private String firstCategoryName;

    /**
     * 二级分类编码
     */
    @TableField("second_category_code")
    private String secondCategoryCode;

    /**
     * 二级分类名称
     */
    @TableField("second_category_name")
    private String secondCategoryName;

    /**
     * 计算公式
     */
    @TableField("calculation_formula")
    private String calculationFormula;

    /**
     * 条件值（范围内的值）
     */
    @TableField("conditional_value")
    private String conditionalValue;

    /**
     * 条件-最小值（在范围条件中表示最小值）
     */
    @TableField("min_value")
    private BigDecimal minValue;

    /**
     * 条件-最大值（在范围条件中表示最大值）
     */
    @TableField("max_value")
    private BigDecimal maxValue;

    /**
     * 条件-是否包含最小值（是否包含最小值，1表示包含，0表示不包含）
     */
    @TableField("include_min")
    private Integer includeMin;

    /**
     * 条件-是否包含最大值（是否包含最大值，1表示包含，0表示不包含）
     */
    @TableField("include_max")
    private Integer includeMax;

    /**
     * 优先级（数字越小优先级越高）
     */
    @TableField("priority")
    private Integer priority;

    /**
     * 描述
     */
    @TableField("description")
    private String description;

    /**
     * 显示顺序
     */
    @TableField("display_order")
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
