package com.yd.csf.feign.dto.excel;

import com.yd.common.enums.DictTypeEnum;
import com.yd.common.utils.DateUtil;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 保单持有人资料（投保人信息）
 */
@Data
public class ApiExcelPolicyholderDto {

    //============以下是表字段============
    /**
     * 中文姓名（投保人信息表：名字）
     */
    private String name;

    /**
     * 英文姓名 (同护照)（投保人信息表：名字-英文）
     */
    private String nameEn;

    /**
     * 性别（投保人信息表：性别）
     */
    private String gender;

    /**
     * 婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（投保人信息表：婚姻状况（字典））
     */
    private String maritalStatus;

    /**
     * 出生日期 (西元 年/月/日)（投保人信息表：出生日期）
     */
    private LocalDateTime birthday;

    /**
     * 出生地 (省/市)（投保人信息表：出生地（省市））
     */
    private String birthplace;

    /**
     * 國籍（投保人信息表：国籍）
     */
    private String nationality;

    /**
     * 身份证号码（投保人信息表：证件号码）
     */
    private String idNumber;

    /**
     * 護照號碼（投保人信息表：护照号码）
     */
    private String passportNo;

    /**
     * 港澳通行证号码（投保人信息表：通行证号码）
     */
    private String passNo;

    /**
     * 永久(住宅)地址（投保人信息表：居住地址）
     */
    private String residentialAddress;

    /**
     * 通訊地址（投保人信息表：通讯地址）
     */
    private String mailingAddress;

    /**
     * 聯絡電話(手機)区号（投保人信息表：移动电话区号）
     */
    private String mobileCode;

    /**
     * 聯絡電話(手機)（投保人信息表：移动电话） 区号+号码
     */
    private String mobile;

    /**
     * 聯絡電話(住宅) 区号+号码 TODO
     */
    private String residenceMobile;

    /**
     * 电邮地址（投保人信息表：邮箱）
     */
    private String email;

    /**
     * 教育程度 (大學或以上/大專/中學/小學或以下)（投保人信息表：教育程度（字典））
     */
    private String educationLevel;

    /**
     * 公司名称（投保人信息表：公司名称）
     */
    private String companyName;

    /**
     * 工作年期(僅限數字)（投保人信息表：总工作年期）
     */
    private BigDecimal totalWorkingYears;

    /**
     * 职位及日常职务（投保人信息表：职位）
     */
    private String position;

    /**
     * 公司业务性质（投保人信息表：TODO）
     */
    private String companyNature;

    /**
     * 公司地址（投保人信息表：公司地址）
     */
    private String companyAddress;

    /**
     * 现时每月收入 (HKD)（投保人信息表：现时每月收入）
     */
    private BigDecimal currentMonthlyIncome;


    //============以下是excel显示的字段，同上============

    /**
     * 中文姓名（投保人信息表：名字）
     */
    private String policyholderName;

    /**
     * 英文姓名 (同护照)（投保人信息表：名字-英文）
     */
    private String policyholderNameEn;

    /**
     * 性别（投保人信息表：性别）
     */
    private String policyholderGender;

    /**
     * 婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（投保人信息表：婚姻状况（字典））
     */
    private String policyholderMaritalStatus;

    /**
     * 出生日期 (西元 年/月/日)（投保人信息表：出生日期）
     */
    private String policyholderBirthday;

    /**
     * 出生地 (省/市)（投保人信息表：出生地（省市））
     */
    private String policyholderBirthplace;

    /**
     * 國籍（投保人信息表：国籍）
     */
    private String policyholderNationality;

    /**
     * 身份证号码（投保人信息表：证件号码）
     */
    private String policyholderIdNumber;

    /**
     * 護照號碼（投保人信息表：护照号码）
     */
    private String policyholderPassportNo;

    /**
     * 港澳通行证号码（投保人信息表：通行证号码）
     */
    private String policyholderPassNo;

    /**
     * 永久(住宅)地址（投保人信息表：居住地址）
     */
    private String policyholderResidentialAddress;

    /**
     * 通訊地址（投保人信息表：通讯地址）
     */
    private String policyholderMailingAddress;

    /**
     * 聯絡電話(手機)（投保人信息表：移动电话） 区号+号码
     */
    private String policyholderMobile;

    /**
     * 聯絡電話(住宅) 区号+号码 TODO
     */
    private String policyholderResidenceMobile;

    /**
     * 电邮地址（投保人信息表：邮箱）
     */
    private String policyholderEmail;

    /**
     * 教育程度 (大學或以上/大專/中學/小學或以下)（投保人信息表：教育程度（字典））
     */
    private String policyholderEducationLevel;

    /**
     * 公司名称（投保人信息表：公司名称）
     */
    private String policyholderCompanyName;

    /**
     * 工作年期(僅限數字)（投保人信息表：总工作年期）
     */
    private BigDecimal policyholderTotalWorkingYears;

    /**
     * 职位及日常职务（投保人信息表：职位）
     */
    private String policyholderPosition;

    /**
     * 公司业务性质（投保人信息表：TODO）
     */
    private String policyholderCompanyNature;

    /**
     * 公司地址（投保人信息表：公司地址）
     */
    private String policyholderCompanyAddress;

    /**
     * 现时每月收入 (HKD)（投保人信息表：现时每月收入）
     */
    private BigDecimal policyholderCurrentMonthlyIncome;

    /**
     * 重新赋值ApiExcelPolicyholderDto
     * @param dto
     * @return
     */
    public static ApiExcelPolicyholderDto setApiExcelPolicyholderDto(ApiExcelPolicyholderDto dto,
                                                                     List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        ApiExcelPolicyholderDto insurantDto = new ApiExcelPolicyholderDto();
        BeanUtils.copyProperties(dto,insurantDto);
        insurantDto.setPolicyholderBirthday(DateUtil.getyyyyMMdd(dto.getBirthday()));
        //出生地 (省/市)（投保人信息表：出生地（省市））TODO
        insurantDto.setPolicyholderBirthplace(dto.getBirthplace());
        insurantDto.setPolicyholderCompanyAddress(dto.getCompanyAddress());
        insurantDto.setPolicyholderCompanyName(dto.getCompanyName());
        insurantDto.setPolicyholderCurrentMonthlyIncome(dto.getCurrentMonthlyIncome());
        //教育程度 (大學或以上/大專/中學/小學或以下)（投保人信息表：教育程度（字典））
        insurantDto.setPolicyholderEducationLevel(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_EDUCATION.getItemValue(),dto.getEducationLevel()));
        insurantDto.setPolicyholderEmail(dto.getEmail());
        //性别（投保人信息表：性别  字典）
        insurantDto.setPolicyholderGender(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.SYS_GENDER.getItemValue(),dto.getGender()));
        insurantDto.setPolicyholderIdNumber(dto.getIdNumber());
        insurantDto.setPolicyholderMailingAddress(dto.getMailingAddress());
        //婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（投保人信息表：婚姻状况（字典））
        insurantDto.setPolicyholderMaritalStatus(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_MARRIAGE.getItemValue(),dto.getMaritalStatus()));
        insurantDto.setPolicyholderMobile(dto.getMobileCode() + "-" + dto.getMobile());
        insurantDto.setPolicyholderName(dto.getName());
        insurantDto.setPolicyholderNameEn(dto.getNameEn());
        //國籍（投保人信息表：国籍）字典 TODO
        insurantDto.setPolicyholderNationality(dto.getNationality());
        insurantDto.setPolicyholderPassNo(dto.getPassNo());
        insurantDto.setPolicyholderPassportNo(dto.getPassportNo());
        //公司业务性质（投保人信息表：TODO）
        insurantDto.setPolicyholderCompanyNature(dto.getCompanyNature());
        insurantDto.setPolicyholderPosition(dto.getPosition());
        //聯絡電話(住宅) 区号+号码 TODO
        insurantDto.setPolicyholderResidenceMobile(dto.getResidenceMobile());
        insurantDto.setPolicyholderResidentialAddress(dto.getResidentialAddress());
        insurantDto.setPolicyholderTotalWorkingYears(dto.getTotalWorkingYears());
        return insurantDto;
    }
}
