package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.result.Result;
import com.yd.csf.service.dto.PolicyBeneficiaryListUpdateRequest;
import com.yd.csf.service.dto.PolicyBeneficiaryQueryRequest;
import com.yd.csf.service.dto.PolicyBeneficiaryUpdateRequest;
import com.yd.csf.service.dto.PolicyBeneficiaryAddRequest;
import com.yd.csf.service.model.PolicyBeneficiary;
import com.yd.csf.service.service.PolicyBeneficiaryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * policy_beneficiary接口
 *
 * @author jianan
 * @since 2025-09-20
 */
@RestController
@RequestMapping("/policy_beneficiary")
@Tag(name = "保单受益人接口")
public class ApiPolicyBeneficiaryController {

    @Resource
    private PolicyBeneficiaryService policyBeneficiaryService;

    /**
     * 创建保单受益人
     *
     * @param policyBeneficiaryAddRequest
     * @param request
     * @return
     */
    @Operation(summary = "创建保单受益人")
    @PostMapping("/add")
    public Result<Map<String, Object>> addPolicyBeneficiary(@RequestBody PolicyBeneficiaryAddRequest policyBeneficiaryAddRequest, HttpServletRequest request) {
        if (policyBeneficiaryAddRequest == null) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        return Result.success(policyBeneficiaryService.addPolicyBeneficiary(policyBeneficiaryAddRequest));
    }

    /**
     * 删除保单受益人
     *
     * @param policyBeneficiaryBizId
     * @param request
     * @return
     */
    @DeleteMapping("/delete")
    @Operation(summary = "删除保单受益人")
    public Result<Boolean> deletePolicyBeneficiary(@RequestParam("policyBeneficiaryBizId") String policyBeneficiaryBizId, HttpServletRequest request) {
        if (policyBeneficiaryBizId == null || StringUtils.isBlank(policyBeneficiaryBizId)) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "policyBeneficiaryBizId不能为空");
        }
//        User user = userService.getLoginUser(request);
//        long id = deleteRequest.getId();
        // 判断是否存在
        PolicyBeneficiary policyBeneficiary = policyBeneficiaryService.getByBizId(policyBeneficiaryBizId);
        if (policyBeneficiary == null) {
            return Result.fail(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }
        // 仅本人或管理员可删除
//        if (!oldFna.getUserId().equals(user.getId()) && !userService.isAdmin(request)) {
//            throw new BusinessException(ErrorCode.NO_AUTH_ERROR);
//        }

        // 操作数据库
        return Result.success(policyBeneficiaryService.removeById(policyBeneficiary.getId()));
    }

    /**
     * 更新保单受益人（产品计划）
     *
     * @param policyUpdateRequest
     * @return
     */
    @PostMapping("/update")
    @Operation(summary = "更新保单受益人信息")
    public Result<Boolean> updatePolicyBeneficiary(@RequestBody PolicyBeneficiaryUpdateRequest policyUpdateRequest) {
        if (policyUpdateRequest == null || StringUtils.isBlank(policyUpdateRequest.getPolicyBeneficiaryBizId())) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "policyBeneficiaryBizId不能为空");
        }
        return Result.success(policyBeneficiaryService.updatePolicyBeneficiary(policyUpdateRequest));
    }

    /**
     * 受益人列表整体更新
     *
     * @param policyBeneficiaryUpdateRequest
     * @return
     */
    @PostMapping("/update/list")
    @Operation(summary = "更新保单受益人列表信息")
    public Result<Boolean> updatePolicyBeneficiaryList(@RequestBody PolicyBeneficiaryListUpdateRequest policyBeneficiaryUpdateRequest) {
        if (policyBeneficiaryUpdateRequest == null || StringUtils.isBlank(policyBeneficiaryUpdateRequest.getPolicyBizId())) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "policyBizId不能为空");
        }
        return Result.success(policyBeneficiaryService.updatePolicyBeneficiaryList(policyBeneficiaryUpdateRequest));
    }

    /**
     * 根据 policyBeneficiaryBizId 获取保单受益人（封装类）
     *
     * @param policyBeneficiaryBizId
     * @return
     */
    @GetMapping("/get/vo")
    @Operation(summary = "根据 policyBeneficiaryBizId 获取保单受益人详情")
    public Result<PolicyBeneficiary> getPolicyByPolicyBeneficiaryBizId(@RequestParam("policyBeneficiaryBizId") String policyBeneficiaryBizId, HttpServletRequest request) {
        if (policyBeneficiaryBizId == null) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        // 查询数据库
        PolicyBeneficiary policyBeneficiary = policyBeneficiaryService.getByBizId(policyBeneficiaryBizId);
        if (policyBeneficiary == null) {
            return Result.fail(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }

        // 获取封装类
        return Result.success(policyBeneficiary);
    }
    
    /**
     * 分页获取保单受益人列表
     *
     * @param policyBeneficiaryQueryRequest
     * @param request
     * @return
     */
    @PostMapping("/list")
    @Operation(summary = "分页获取保单受益人列表")
    public Result<Page<PolicyBeneficiary>> listPolicyByPage(@RequestBody PolicyBeneficiaryQueryRequest policyBeneficiaryQueryRequest,
                                                               HttpServletRequest request) {
        long current = policyBeneficiaryQueryRequest.getPageNo();
        long size = policyBeneficiaryQueryRequest.getPageSize();

        // 查询数据库
        QueryWrapper<PolicyBeneficiary> queryWrapper = new QueryWrapper<PolicyBeneficiary>();
        queryWrapper.eq("policy_biz_id", policyBeneficiaryQueryRequest.getPolicyBizId());
        queryWrapper.orderByAsc("id");
        Page<PolicyBeneficiary> PolicyBeneficiaryPage = policyBeneficiaryService.page(new Page<>(current, size),
                queryWrapper);
        // 获取封装类
        return Result.success(PolicyBeneficiaryPage);
    }

}
