package com.yd.csf.service.vo;

import com.yd.csf.service.model.Fna;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * fna视图
 *
 */
@Data
public class FnaVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 内容
     */
    private String content;

    /**
     * 创建用户 id
     */
    private Long userId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 标签列表
     */
    private List<String> tagList;

    /**
     * 创建用户信息
     */
//    private UserVO user;

    /**
     * 封装类转对象
     *
     * @param fnaVO
     * @return
     */
    public static Fna voToObj(FnaVO fnaVO) {
        if (fnaVO == null) {
            return null;
        }
        Fna fna = new Fna();
        BeanUtils.copyProperties(fnaVO, fna);
        List<String> tagList = fnaVO.getTagList();

        return fna;
    }

    /**
     * 对象转封装类
     *
     * @param fna
     * @return
     */
    public static FnaVO objToVo(Fna fna) {
        if (fna == null) {
            return null;
        }
        FnaVO fnaVO = new FnaVO();
        BeanUtils.copyProperties(fna, fnaVO);

        return fnaVO;
    }
}
