package com.yd.csf.service.vo;

import cn.hutool.json.JSONUtil;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yd.csf.service.model.Customer;
import com.yd.csf.service.model.CustomerExpand;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * customer视图
 *
 */
@Data
public class CustomerVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 唯一业务ID
     */
    private String customerBizId;

    /**
     * 自定义代码
     */
    private String customCode;

    /**
     * 姓氏
     */
    private String lastName;

    /**
     * 名字
     */
    private String firstName;

    /**
     * 姓名
     */
    private String name;

    /**
     * 姓氏拼音
     */
    private String lastNamePinyin;

    /**
     * 名字拼音
     */
    private String firstNamePinyin;

    /**
     * 拼音全称
     */
    private String pinyin;

    /**
     * 称谓
     */
    private String title;

    /**
     * 性别
     */
    private Object gender;

    /**
     * 生日
     */
    private Date birthday;

    /**
     * 出生日期
     */
    private Date birthdate;

    /**
     * 异常信息
     */
    private String abnormal;

    /**
     * 年龄
     */
    private String age;

    /**
     * 地区代码
     */
    private String areaCode;

    /**
     * 电话号码
     */
    private String phone;

    /**
     * 电子邮箱
     */
    private String email;

    /**
     * 是否吸烟
     */
    private String smoke;

    /**
     * 吸烟数量
     */
    private String smokeQuantity;

    /**
     * 公司类型
     */
    private String companyType;

    /**
     * 来源
     */
    private String source;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 护照号
     */
    private String passport;

    /**
     * EEP代码
     */
    private String eepCode;

    /**
     * 婚姻状况
     */
    private Object marriage;

    /**
     * 出生地
     */
    private String birthplace;

    /**
     * 教育程度
     */
    private Object education;

    /**
     * 签单用户扩展唯一业务ID
     */
    private String customerExpandBizId;

    /**
     * 国家
     */
    private String country;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 客户扩展信息
     */
    private CustomerExpandVO customerExpand;

    /**
     * 封装类转对象
     *
     * @param customerVO
     * @return
     */
    public static Customer voToObj(CustomerVO customerVO) {
        if (customerVO == null) {
            return null;
        }
        Customer customer = new Customer();
        BeanUtils.copyProperties(customerVO, customer);

        return customer;
    }

    /**
     * 对象转封装类
     *
     * @param customer
     * @return
     */
    public static CustomerVO objToVo(Customer customer) {
        if (customer == null) {
            return null;
        }
        CustomerVO customerVO = new CustomerVO();
        BeanUtils.copyProperties(customer, customerVO);

        return customerVO;
    }
}
