package com.yd.csf.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.yd.csf.service.dao.FnaMapper;
import com.yd.csf.service.dto.FnaQueryRequest;
import com.yd.csf.service.model.Fna;
import com.yd.csf.service.service.FnaService;
import com.yd.csf.service.vo.FnaVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * fna服务实现
 *
 */
@Service
@Slf4j
public class FnaServiceImpl extends ServiceImpl<FnaMapper, Fna> implements FnaService {

//    @Resource
//    private UserService userService;


    @Override
    public boolean addFna(Fna fna) {
        Date date = new Date();
        fna.setCreateTime(date);
        fna.setUpdateTime(date);
        return this.save(fna);
    }

    /**
     * 获取查询条件
     *
     * @param fnaQueryRequest
     * @return
     */
    @Override
    public QueryWrapper<Fna> getQueryWrapper(FnaQueryRequest fnaQueryRequest) {
        QueryWrapper<Fna> queryWrapper = new QueryWrapper<>();
        if (fnaQueryRequest == null) {
            return queryWrapper;
        }
        // 客户姓名
        String customerName = fnaQueryRequest.getCustomerName();
        // 预约编号
        String appointmentNo = fnaQueryRequest.getAppointmentNo();
        // 新单编号
        String policyId = fnaQueryRequest.getPolicyId();
        // 保单号
        String policyNo = fnaQueryRequest.getPolicyNo();

        // 客户姓名
        queryWrapper.like(StringUtils.isNotBlank(customerName), "customer_name", customerName);
        // 预约编号
        queryWrapper.like(StringUtils.isNotBlank(appointmentNo), "appointment_no", appointmentNo);
        // 新单编号
        queryWrapper.like(StringUtils.isNotBlank(policyId), "policy_id", policyId);
        // 保单号
        queryWrapper.like(StringUtils.isNotBlank(policyNo), "policy_no", policyNo);

        // 排序规则
        queryWrapper.orderByDesc("id");
        return queryWrapper;
    }

    /**
     * 获取fna封装
     *
     * @param fna
     * @return
     */
    @Override
    public FnaVO getFnaVO(Fna fna) {
        // 对象转封装类
        FnaVO fnaVO = FnaVO.objToVo(fna);

        // region 可选

        // 1. 关联查询用户信息
//        Long userId = fna.getUserId();
//        User user = null;
//        if (userId != null && userId > 0) {
//            user = userService.getById(userId);
//        }
//        UserVO userVO = userService.getUserVO(user);
//        fnaVO.setUser(userVO);
        // 2. 已登录，获取用户点赞、收藏状态
        long fnaId = fna.getId();
//        User loginUser = userService.getLoginUserPermitNull(request);

        // endregion

        return fnaVO;
    }

    /**
     * 分页获取fna封装
     *
     * @param fnaPage
     * @return
     */
    @Override
    public Page<FnaVO> getFnaVOPage(Page<Fna> fnaPage) {
        List<Fna> fnaList = fnaPage.getRecords();
        Page<FnaVO> fnaVOPage = new Page<>(fnaPage.getCurrent(), fnaPage.getSize(), fnaPage.getTotal());
        if (CollUtil.isEmpty(fnaList)) {
            return fnaVOPage;
        }
        // 对象列表 => 封装对象列表
        List<FnaVO> fnaVOList = fnaList.stream().map(fna -> {
            return FnaVO.objToVo(fna);
        }).collect(Collectors.toList());

        // todo 可以根据需要为封装对象补充值，不需要的内容可以删除
        // region 可选
        // 1. 关联查询用户信息
//        Set<Long> userIdSet = fnaList.stream().map(Fna::getUserId).collect(Collectors.toSet());
//        Map<Long, List<User>> userIdUserListMap = userService.listByIds(userIdSet).stream()
//                .collect(Collectors.groupingBy(User::getId));

        // 2. 已登录，获取用户点赞、收藏状态
        Map<Long, Boolean> fnaIdHasThumbMap = new HashMap<>();
        Map<Long, Boolean> fnaIdHasFavourMap = new HashMap<>();
//        User loginUser = userService.getLoginUserPermitNull(request);


        // 填充信息
        fnaVOList.forEach(fnaVO -> {
            Long userId = fnaVO.getUserId();
//            User user = null;
//            if (userIdUserListMap.containsKey(userId)) {
//                user = userIdUserListMap.get(userId).get(0);
//            }
//            fnaVO.setUser(userService.getUserVO(user));
//            fnaVO.setHasThumb(fnaIdHasThumbMap.getOrDefault(fnaVO.getId(), false));
//            fnaVO.setHasFavour(fnaIdHasFavourMap.getOrDefault(fnaVO.getId(), false));
        });
        // endregion

        fnaVOPage.setRecords(fnaVOList);
        return fnaVOPage;
    }

    @Override
    public Fna getByBizId(String fnaBizId) {
        QueryWrapper<Fna> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fna_biz_id", fnaBizId);
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public boolean updateByBizId(Fna fna) {
        UpdateWrapper<Fna> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("fna_biz_id", fna.getFnaBizId());
        return baseMapper.update(fna, updateWrapper) > 0;
    }

}
