package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.ProductPlan;
import com.yd.csf.service.dao.ProductPlanMapper;
import com.yd.csf.service.service.IProductPlanService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 产品计划信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class ProductPlanServiceImpl extends ServiceImpl<ProductPlanMapper, ProductPlan> implements IProductPlanService {

    /**
     * 根据产品计划业务id查询单个对象
     * @param planBizId
     * @return
     */
    @Override
    public ProductPlan queryOne(String planBizId) {
        return this.getOne(new LambdaQueryWrapper<ProductPlan>().eq(ProductPlan::getPlanBizId,planBizId));
    }

    /**
     * 根据预约业务id或者计划业务id查询单个对象
     * @param appointmentBizId
     * @param planBizId
     * @return
     */
    @Override
    public ProductPlan queryOne(String appointmentBizId, String planBizId) {
        return this.getOne(new LambdaQueryWrapper<ProductPlan>()
                .eq(StringUtils.isNotBlank(appointmentBizId),ProductPlan::getAppointmentBizId,appointmentBizId)
                .eq(StringUtils.isNotBlank(planBizId),ProductPlan::getPlanBizId,planBizId));
    }
}
