package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.Policyholder;
import com.yd.csf.service.dao.PolicyholderMapper;
import com.yd.csf.service.service.IPolicyholderService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 投保人信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class PolicyholderServiceImpl extends ServiceImpl<PolicyholderMapper, Policyholder> implements IPolicyholderService {

    /**
     * 查询单个对象
     * @param policyholderBizId
     * @return
     */
    @Override
    public Policyholder queryOne(String policyholderBizId) {
        return this.getOne(new LambdaQueryWrapper<Policyholder>().eq(Policyholder::getPolicyholderBizId,policyholderBizId));
    }

    /**
     * 根据预约业务id和投保人业务id查询单个对象
     * @param appointmentBizId
     * @param policyholderBizId
     * @return
     */
    @Override
    public Policyholder queryOne(String appointmentBizId,
                                 String policyholderBizId) {
        return this.getOne(new LambdaQueryWrapper<Policyholder>()
                .eq(StringUtils.isNotBlank(appointmentBizId),Policyholder::getAppointmentBizId,appointmentBizId)
                .eq(StringUtils.isNotBlank(policyholderBizId),Policyholder::getPolicyholderBizId,policyholderBizId));
    }
}
