package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.csf.service.dto.QueryPolicyBrokerDto;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.model.PolicyBroker;
import com.yd.csf.service.service.PolicyBrokerService;
import com.yd.csf.service.dao.PolicyBrokerMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
* @author Zhang Jianan
* @description 针对表【policy_broker(保单转介人表)】的数据库操作Service实现
* @createDate 2025-09-18 15:06:03
*/
@Service
public class PolicyBrokerServiceImpl extends ServiceImpl<PolicyBrokerMapper, PolicyBroker>
    implements PolicyBrokerService{

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<PolicyBroker> queryList(QueryPolicyBrokerDto dto) {
        List<PolicyBroker> list = baseMapper.selectList(new LambdaQueryWrapper<PolicyBroker>()
                .in(!CollectionUtils.isEmpty(dto.getPolicyNoList()),PolicyBroker::getPolicyNo,dto.getPolicyNoList())
        );
        return list;
    }

    @Override
    public PolicyBroker queryOne(QueryPolicyBrokerDto dto) {
        return this.getOne(new LambdaQueryWrapper<PolicyBroker>()
                .eq(PolicyBroker::getBrokerBizId,dto.getBrokerBizId())
                .eq(PolicyBroker::getPolicyNo,dto.getPolicyNo())
                .last("limit 1")
        );
    }
}




