package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.dto.PolicyAdditionalAddRequest;
import com.yd.csf.service.dto.PolicyAdditionalUpdateRequest;
import com.yd.csf.service.model.PolicyAdditional;
import com.yd.csf.service.service.PolicyAdditionalService;
import com.yd.csf.service.dao.PolicyAdditionalMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Date;
import java.util.Map;

/**
* @author Zhang Jianan
* @description 针对表【policy_additional(保单附加险信息表)】的数据库操作Service实现
* @createDate 2025-11-03 11:05:09
*/
@Service
public class PolicyAdditionalServiceImpl extends ServiceImpl<PolicyAdditionalMapper, PolicyAdditional>
    implements PolicyAdditionalService{

    @Override
    public Map<String, Object> addPolicyAdditional(PolicyAdditionalAddRequest policyAdditionalAddRequest) {
        // 校验请求参数
        if (policyAdditionalAddRequest == null) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        // 转换为实体类
        PolicyAdditional policyAdditional = new PolicyAdditional();
        BeanUtils.copyProperties(policyAdditionalAddRequest, policyAdditional);

        policyAdditional.setAdditionalProductBizId(RandomStringGenerator.generateBizId16("policy_additional"));

        Date now = new Date();
        policyAdditional.setCreateTime(now);
        policyAdditional.setUpdateTime(now);
        // 保存到数据库
        this.saveOrUpdate(policyAdditional);

        // 返回结果
        return Collections.singletonMap("policyAdditionalBizId", policyAdditional.getPolicyAdditionalBizId());
    }

    @Override
    public PolicyAdditional getByBizId(String policyAdditionalBizId) {
        return this.getOne(new QueryWrapper<PolicyAdditional>().eq("policy_additional_biz_id", policyAdditionalBizId));
    }

    @Override
    public Boolean updatePolicyAdditional(PolicyAdditionalUpdateRequest policyUpdateRequest) {
        // 校验请求参数
        if (policyUpdateRequest == null || policyUpdateRequest.getPolicyAdditionalBizId() == null) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        // 转换为实体类
        PolicyAdditional policyAdditional = new PolicyAdditional();
        BeanUtils.copyProperties(policyUpdateRequest, policyAdditional);

        policyAdditional.setUpdateTime(new Date());
        // 保存到数据库
        return this.updateById(policyAdditional);
    }
}




