package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.Insurant;
import com.yd.csf.service.dao.InsurantMapper;
import com.yd.csf.service.model.Policyholder;
import com.yd.csf.service.service.IInsurantService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 受保人信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class InsurantServiceImpl extends ServiceImpl<InsurantMapper, Insurant> implements IInsurantService {

    /**
     * 查询单个对象
     * @param insurantBizId
     * @return
     */
    @Override
    public Insurant queryOne(String insurantBizId) {
        return this.getOne(new LambdaQueryWrapper<Insurant>().eq(Insurant::getInsurantBizId,insurantBizId));
    }

    /**
     * 根据预约业务id和受保人业务id查询单个对象
     * @param appointmentBizId
     * @param insurantBizId
     * @return
     */
    @Override
    public Insurant queryOne(String appointmentBizId, String insurantBizId) {
        return this.getOne(new LambdaQueryWrapper<Insurant>()
                .eq(StringUtils.isNotBlank(appointmentBizId),Insurant::getAppointmentBizId,appointmentBizId)
                .eq(StringUtils.isNotBlank(insurantBizId),Insurant::getInsurantBizId,insurantBizId));
    }
}
