package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFilePageRequest;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentFilePageResponse;
import com.yd.csf.service.model.Additional;
import com.yd.csf.service.model.AppointmentFile;
import com.yd.csf.service.dao.AppointmentFileMapper;
import com.yd.csf.service.service.IAppointmentFileService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 预约附件信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class AppointmentFileServiceImpl extends ServiceImpl<AppointmentFileMapper, AppointmentFile> implements IAppointmentFileService {

    @Override
    public IPage<ApiAppointmentFilePageResponse> page(Page<ApiAppointmentFilePageResponse> page,
                                                      ApiAppointmentFilePageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param appointmentFileBizId
     * @return
     */
    @Override
    public AppointmentFile queryOne(String appointmentFileBizId) {
        return this.getOne(new LambdaQueryWrapper<AppointmentFile>()
                .eq(AppointmentFile::getAppointmentFileBizId,appointmentFileBizId));
    }

    /**
     * 查询列表信息
     * @param appointmentBizId
     * @return
     */
    @Override
    public List<AppointmentFile> queryList(String appointmentBizId) {
        List<AppointmentFile> list = baseMapper.selectList(new LambdaQueryWrapper<AppointmentFile>()
                .eq(StringUtils.isNotBlank(appointmentBizId),AppointmentFile::getAppointmentBizId,appointmentBizId)
        );
        return list;
    }
}
