package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 会员等级配置表
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("member_grade_config")
public class MemberGradeConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 会员等级配置表唯一业务ID
     */
    @TableField("grade_biz_id")
    private String gradeBizId;

    /**
     * 等级编码
     */
    @TableField("grade_code")
    private String gradeCode;

    /**
     * 等级名称
     */
    @TableField("grade_name")
    private String gradeName;

    /**
     * 拥有等级有无条件限制（0-无 1-有。例：如果1-有，在对象和规则条件配置关系表配置）
     */
    @TableField("is_condition")
    private Integer isCondition;

    /**
     * 积分比例。例：91%、100%
     */
    @TableField("integral_ratio")
    private BigDecimal integralRatio;

    /**
     * 等级描述
     */
    @TableField("description")
    private String description;

    /**
     * 显示顺序
     */
    @TableField("display_order")
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
