package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 来佣修改记录表
 * @TableName commission_edit_record
 */
@TableName(value ="commission_edit_record")
@Data
public class CommissionEditRecord implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 保单来佣业务id
     */
    @Schema(description = "保单来佣业务id")
    private String commissionBizId;

    /**
     * 操作人userid
     */
    @Schema(description = "操作人userid")
    private String userBizId;

    /**
     * 操作人
     */
    @Schema(description = "操作人")
    private String userName;

    /**
     * 序号
     */
    @Schema(description = "序号")
    private Integer seq;

    /**
     * 变更字段
     */
    @Schema(description = "变更字段")
    private String field;

    /**
     * 变更前信息
     */
    @Schema(description = "变更前信息")
    private Object beforeChange;

    /**
     * 变更后信息
     */
    @Schema(description = "变更后信息")
    private Object afterChange;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}