package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class PolicyBeneficiaryAddRequest {
    /**
     * 新单跟进业务ID
     */
    @Schema(description = "新单跟进业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 客户类型（字典）(个人或者公司)
     */
    @Schema(description = "客户类型（字典）(个人或者公司)")
    private String customerType;

    /**
     * 与受保人关系（字典）
     */
    @Schema(description = "与受保人关系（字典）")
    private String insurantRel;

    /**
     * 受益比例
     */
    @Schema(description = "受益比例")
    private BigDecimal benefitRatio;

    /**
     * 名字
     */
    @Schema(description = "名字")
    private String name;

    /**
     * 名字-英文
     */
    @Schema(description = "名字-英文")
    private String nameEn;

    /**
     * 性别（字典）
     */
    @Schema(description = "性别（字典）")
    private String gender;

    /**
     * 证件类型（字典）
     */
    @Schema(description = "证件类型（字典）")
    private String documentType;

    /**
     * 证件号码
     */
    @Schema(description = "证件号码")
    private String idNumber;

    /**
     * 护照号码
     */
    @Schema(description = "护照号码")
    private String passportNumber;

    /**
     * 出生日期
     */
    @Schema(description = "出生日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthTime;

    /**
     * 公司名称
     */
    @Schema(description = "公司名称")
    private String companyName;

    /**
     * 公司名称（英文）
     */
    @Schema(description = "公司名称（英文）")
    private String companyNameEn;

    /**
     * 公司商业登记号码
     */
    @Schema(description = "公司商业登记号码")
    private String companyBusinessNo;

    /**
     * 公司注册日期
     */
    @Schema(description = "公司注册日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date companyRegisterTime;

    /**
     * 公司注册地区（字典）
     */
    @Schema(description = "公司注册地区（字典）")
    private String companyRegisterRegion;

    /**
     * 公司电话区号
     */
    @Schema(description = "公司电话区号")
    private String companyMobileCode;

    /**
     * 公司电话
     */
    @Schema(description = "公司电话")
    private String companyMobile;

    /**
     * 公司邮箱
     */
    @Schema(description = "公司邮箱")
    private String companyEmail;

    /**
     * 公司登记地址
     */
    @Schema(description = "公司登记地址")
    private String companyEnterAddress;

    /**
     * 通讯地址
     */
    @Schema(description = "通讯地址")
    private String mailingAddress;

    /**
     * 授权代表姓名中文-名字
     */
    @Schema(description = "授权代表姓名中文-名字")
    private String authNameCn;

    /**
     * 授权代表姓名英文-名字
     */
    @Schema(description = "授权代表姓名英文-名字")
    private String authNameEn;

    /**
     * 授权代表职称
     */
    @Schema(description = "授权代表职称")
    private String authProfessional;

    /**
     * 授权代表电话区号
     */
    @Schema(description = "授权代表电话区号")
    private String authMobileCode;

    /**
     * 授权代表电话
     */
    @Schema(description = "授权代表电话")
    private String authMobile;

    /**
     * 地址列表（json串）
     */
    @Schema(description = "地址列表（json串）")
    private Object addressList;

    /**
     * 通用备注
     */
    @Schema(description = "通用备注")
    private String remark;
}
