package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class PolicyAdditionalAddRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 新单跟进业务ID
     */
    @Schema(description = "新单跟进业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 产品计划信息表唯一业务ID
     */
    @Schema(description = "产品计划信息表唯一业务ID")
    private String planBizId;

    /**
     * 保险附加产品唯一业务ID（中台保险附加产品业务id，冗余）
     */
    @Schema(description = "保险附加产品唯一业务ID（中台保险附加产品业务id，冗余）")
    private String additionalProductBizId;

    /**
     * 保险附加产品名称（中台保险附加产品名称，冗余）
     */
    @Schema(description = "保险附加产品名称（中台保险附加产品名称，冗余）")
    private String addProductName;

    /**
     * 货币（字典）
     */
    @Schema(description = "货币（字典）")
    private String currency;

    /**
     * 保费
     */
    @Schema(description = "保费")
    private BigDecimal premium;

    /**
     * 保额
     */
    @Schema(description = "保额")
    private BigDecimal sumInsured;

    /**
     * 保障地区（字典）
     */
    @Schema(description = "保障地区（字典）")
    private String guaranteeRegion;

    /**
     * 等级（字典）
     */
    @Schema(description = "等级（字典）")
    private String level;

    /**
     * 自付额（字典）
     */
    @Schema(description = "自付额（字典）")
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    @Schema(description = "附加保障（json串）")
    private String additionalSafeguards;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
