package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 查询fortune请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FortuneQueryRequest extends PageDto implements Serializable {
    /**
     * 发佣状态
     */
    @Schema(description = "发佣状态 '0'-'暂不可发','1'-'可发放','2'-'已发并关账', 字典值: csf_fortune_status")
    private String status;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    private static final long serialVersionUID = 1L;
}