package com.yd.csf.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AgentReferralRelationDto {

    /**
     * 推荐人ID（客户端用户表唯一业务ID，如果是PC，这里就是sys_user的用户ID）
     */
    private String referrerId;

    /**
     * 被推荐人ID（客户端用户表唯一业务ID）列表
     */
    private List<String> agentIdList;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    private String projectBizId;
}
