package com.yd.csf.feign.response.formulaconfig;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiFormulaConfigDetailResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 公式配置表唯一业务ID
     */
    private String formulaBizId;

    /**
     * 公式编码
     */
    private String code;

    /**
     * 公式名称
     */
    private String name;

    /**
     * 计算公式（变量中文名称组合，用于展示）
     */
    private String calculationFormulaCn;

    /**
     * 计算公式（变量表唯一业务ID组合）
     */
    private String calculationFormulaBizId;

    /**
     * 描述
     */
    private String description;

    /**
     * 显示顺序
     */
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
