package com.yd.csf.feign.response.commissionsqltemplate;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiCommissionSqlTemplatePageResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * SQL模板表唯一业务ID
     */
    private String sqlTemplateBizId;

    /**
     * 模板编码
     */
    private String sqlTemplateCode;

    /**
     * 模板名称
     */
    private String sqlTemplateName;

    /**
     * 模板类型
     */
    private String sqlTemplateType;

    /**
     * 模板详细描述
     */
    private String description;

    /**
     * SQL模板内容，支持参数化查询，使用 :参数名 作为占位符，如：SELECT SUM(fyc) FROM policy WHERE agent_id = :agentId AND period = :period
     */
    private String sqlTemplate;

    /**
     * 参数定义，JSON格式，定义SQL模板所需的参数列表，如：[{"name": "agentId", "type": "STRING", "required": true, "description": "业务员ID"}, {"name": "period", "type": "STRING", "required": true, "description": "计算周期"}]
     */
    private String parameters;

    /**
     * 显示顺序
     */
    private Integer displayOrder;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
