package com.yd.csf.feign.dto.excel;

import com.yd.common.utils.DateUtil;
import com.yd.csf.feign.dto.appointment.ApiAppointmentInfoDto;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * Excel-客戶在港/澳停留時間信息
 */
@Data
public class ApiExcelHkStayDto {

    //============以下是表字段============
    /**
     * 抵港(澳)日期及时间（到港时间）（预约信息主表）
     */
    private LocalDateTime arrivalTime;

    /**
     * 离港(澳)日期及时间（离港时间）（预约信息主表）
     */
    private LocalDateTime departureTime;

    /**
     * 会面地点（字典）（会面地点）
     */
    private String meetingPoint;

    /**
     * 客户在港期间联络电话区号（预约信息主表）
     */
    private String hkMobileCode;

    /**
     * 客户在港期间联络电话（预约信息主表）区号+号码
     */
    private String hkMobile;

    /**
     * 随行人员姓名（陪同顾问姓名（FNA Form有填写，可带入））（预约信息主表）
     */
    private String accompanyName;

    /**
     * 隨行人員聯絡電話区号（陪同顾问手机区号）（预约信息主表）
     */
    private String accompanyMobileCode;

    /**
     * 隨行人員聯絡電話（陪同顾问手机）（预约信息主表）区号+号码
     */
    private String accompanyMobile;

    //============以下是excel显示的字段，同上============
    /**
     * 抵港(澳)日期及时间（到港时间）（预约信息主表）
     */
    private String hkArrivalTime;

    /**
     * 离港(澳)日期及时间（离港时间）（预约信息主表）
     */
    private String hkDepartureTime;

    /**
     * 会面地点（字典）（会面地点）
     */
    private String hkMeetingPoint;

    /**
     * 客户在港期间联络电话（预约信息主表）区号+号码
     */
    private String hkHkMobile;

    /**
     * 随行人员姓名（陪同顾问姓名（FNA Form有填写，可带入））（预约信息主表）
     */
    private String hkAccompanyName;

    /**
     * 隨行人員聯絡電話（陪同顾问手机）（预约信息主表）区号+号码
     */
    private String hkAccompanyMobile;

    /**
     * 重新赋值ApiExcelHkStayDto
     * @param dto
     * @return
     */
    public static ApiExcelHkStayDto setApiExcelHkStayDto(ApiExcelHkStayDto dto,
                                                         List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        ApiExcelHkStayDto stayDto = new ApiExcelHkStayDto();
        BeanUtils.copyProperties(dto,stayDto);
        stayDto.setHkAccompanyMobile(dto.getAccompanyMobileCode() + "-" + dto.getAccompanyMobile());
        stayDto.setHkAccompanyName(dto.getAccompanyName());
        //抵港(澳)日期及时间（到港时间）（预约信息主表）年-月-日 时:分
        stayDto.setHkArrivalTime(DateUtil.getyyyyMMddHHmm(dto.getArrivalTime()));
        //离港(澳)日期及时间（离港时间）（预约信息主表）年-月-日 时:分
        stayDto.setHkDepartureTime(DateUtil.getyyyyMMddHHmm(dto.getDepartureTime()));
        stayDto.setHkHkMobile(dto.getHkMobileCode() + "-" + dto.getHkMobile());
        stayDto.setHkMeetingPoint(dto.getMeetingPoint());
        return stayDto;
    }

    /**
     * ApiExcelHkStayDto构造ApiAppointmentInfoDto用于保存到表
     * @param dto
     * @return
     */
    public static ApiAppointmentInfoDto setApiAppointmentInfoDto(ApiExcelHkStayDto dto) {
        ApiAppointmentInfoDto infoDto = new ApiAppointmentInfoDto();
        return infoDto;
    }
}
