package com.yd.csf.feign.dto.appointment;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 产品计划-附加险列表
 */
@Data
public class ApiProductPlanAdditionalInfoDto {

    /**
     * 产品计划-附加险信息表主键id（新增不需要传值，编辑需要传值）
     */
    private Long id;

    /**
     * 附加险信息表唯一业务ID（新增不需要传值，编辑需要传值）
     */
    private String additionalBizId;

    /**
     * 产品计划信息表唯一业务ID（新增不需要传值，编辑需要传值）
     */
    private String planBizId;

    /**
     * 保险附加产品唯一业务ID（中台保险附加产品业务id，冗余）
     */
//    @NotBlank(message = "保险附加产品唯一业务ID不能为空")
    private String additionalProductBizId;

    /**
     * 保险附加产品名称（中台保险附加产品名称，冗余）
     */
//    @NotBlank(message = "保险附加产品名称不能为空")
    private String addProductName;

    /**
     * 货币（字典）
     */
//    @NotBlank(message = "货币不能为空")
    private String currency;

    /**
     * 保费
     */
//    @NotNull(message = "保费不能为空")
    private BigDecimal premium;

    /**
     * 保额
     */
//    @NotNull(message = "保额不能为空")
    private BigDecimal sumInsured;

    /**
     * 保障地区（字典）
     */
    private String guaranteeRegion;

    /**
     * 等级（字典）
     */
    private String level;

    /**
     * 自付额（字典）
     */
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    private String additionalSafeguards;
}
