package com.yd.csf.feign.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 地址DTO
 */
@Data
public class AddressDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 地址类型 residenceAddress-居住地址、residentialAddress-住宅地址、mailingAddress-邮寄地址、companyAddress-公司地址
     * 公司登记地址-companyEnterAddress 通讯地址-txAddress
     */
    private String type;

    /**
     * 区域
     */
    private String region;

    /**
     * 城市（省份+城市）
     */
    private String city;

    /**
     * 街道
     */
    private String street;

    /**
     * 详细地址
     */
    private String location;

}
