package com.yd.csf.feign.client.secondholder;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiSecondHolderInfoDto;
import com.yd.csf.feign.fallback.secondholder.ApiSecondHolderFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-第二持有人信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiSecondHolderFeignFallbackFactory.class)
public interface ApiSecondHolderFeignClient {

    /**
     * 编辑第二持有人信息
     * @param apiSecondHolderInfoDto
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSecondHolderInfoDto apiSecondHolderInfoDto);

    /**
     * 第二持有人信息详情
     * @param appointmentBizId 预约信息主表唯一业务ID
     * @param secondHolderBizId 第二持有人信息表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSecondHolderInfoDto> detail(
            @RequestParam(value = "appointmentBizId") String appointmentBizId,
            @RequestParam(value = "secondHolderBizId") String secondHolderBizId);
}
