package com.yd.csf.feign.client.insurant;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiInsurantInfoDto;
import com.yd.csf.feign.dto.appointment.ApiPolicyholderInfoDto;
import com.yd.csf.feign.fallback.insurant.ApiInsurantFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-受保人信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiInsurantFeignFallbackFactory.class)
public interface ApiInsurantFeignClient {

    /**
     * 编辑受保人信息
     * @param apiInsurantInfoDto
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiInsurantInfoDto apiInsurantInfoDto);

    /**
     * 受保人信息详情
     * @param appointmentBizId 预约信息主表唯一业务ID
     * @param insurantBizId 受保人信息表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiInsurantInfoDto> detail(
            @RequestParam(value = "appointmentBizId") String appointmentBizId,
            @RequestParam(value = "insurantBizId") String insurantBizId);
}
