package com.yd.csf.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.csf.api.dto.ApiExpectedFortuneLogDto;
import com.yd.csf.api.service.ApiExpectedFortuneLogService;
import com.yd.csf.feign.request.expectedfortunelog.ApiExpectedFortuneLogPageRequest;
import com.yd.csf.feign.response.expectedfortunelog.ApiExpectedFortuneLogPageResponse;
import com.yd.csf.service.model.ExpectedFortuneLog;
import com.yd.csf.service.service.IExpectedFortuneLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
public class ApiExpectedFortuneLogServiceImpl implements ApiExpectedFortuneLogService {

    @Autowired
    private IExpectedFortuneLogService iExpectedFortuneLogService;

    /**
     * 分页查询 - 生成预计发佣日志记录
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedFortuneLogPageResponse>> page(ApiExpectedFortuneLogPageRequest request) {
        Page<ApiExpectedFortuneLogPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiExpectedFortuneLogPageResponse> iPage = iExpectedFortuneLogService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 保存预计发佣日志记录
     * @param dto
     * @return
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public Result saveExpectedFortuneLog(ApiExpectedFortuneLogDto dto) {
        ExpectedFortuneLog expectedFortuneLog = new ExpectedFortuneLog();
        BeanUtils.copyProperties(dto,expectedFortuneLog);
        iExpectedFortuneLogService.saveOrUpdate(expectedFortuneLog);
        return Result.success();
    }

}
