package com.yd.csf.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiCommissionSqlTemplateService;
import com.yd.csf.feign.request.commissionsqltemplate.ApiCommissionSqlTemplatePageRequest;
import com.yd.csf.feign.response.commissionsqltemplate.ApiCommissionSqlTemplatePageResponse;
import com.yd.csf.service.service.ICommissionSqlTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiCommissionSqlTemplateServiceImpl implements ApiCommissionSqlTemplateService {

    @Autowired
    private ICommissionSqlTemplateService iCommissionSqlTemplateService;

    /**
     * 分页查询-SQL模板信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiCommissionSqlTemplatePageResponse>> page(ApiCommissionSqlTemplatePageRequest request) {
        Page<ApiCommissionSqlTemplatePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiCommissionSqlTemplatePageResponse> iPage = iCommissionSqlTemplateService.page(page, request);
        return Result.success(iPage);
    }
}
