package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiFormulaConfigService;
import com.yd.csf.feign.client.formulaconfig.ApiFormulaConfigFeignClient;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigAddRequest;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigEditRequest;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigPageRequest;
import com.yd.csf.feign.response.formulaconfig.ApiFormulaConfigDetailResponse;
import com.yd.csf.feign.response.formulaconfig.ApiFormulaConfigPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公式配置信息
 *
 * @author zxm
 * @since 2025-10-17
 */
@RestController
@RequestMapping("/formulaConfig")
@Validated
public class ApiFormulaConfigController implements ApiFormulaConfigFeignClient {

    @Autowired
    private ApiFormulaConfigService apiFormulaConfigService;

    /**
     * 分页查询-公式配置信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiFormulaConfigPageResponse>> page(ApiFormulaConfigPageRequest request) {
        return apiFormulaConfigService.page(request);
    }

    /**
     * 详情-公式配置信息
     * @param formulaBizId
     * @return
     */
    @Override
    public Result<ApiFormulaConfigDetailResponse> detail(String formulaBizId) {
        return apiFormulaConfigService.detail(formulaBizId);
    }

    /**
     * 添加-公式配置信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiFormulaConfigAddRequest request) {
        return apiFormulaConfigService.add(request);
    }

    /**
     * 编辑-公式配置信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiFormulaConfigEditRequest request) {
        return apiFormulaConfigService.edit(request);
    }

    /**
     * 删除-公式配置信息 TODO
     * @param formulaBizId
     * @return
     */
    @Override
    public Result del(String formulaBizId) {
        return apiFormulaConfigService.del(formulaBizId);
    }
}
