package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 查询customer请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerQueryRequest extends PageDto implements Serializable {

    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String name;

    /**
     * 标题
     */
    @Schema(description = "手机号")
    private String phone;

    /**
     * 内容
     */
    @Schema(description = "邮箱")
    private String email;

    private static final long serialVersionUID = 1L;
}