package com.yd.csf.service.dto;

import com.yd.csf.service.model.*;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 新单跟进聚合查询结果DTO
 */
@Data
public class PolicyFollowAggregateDto implements Serializable {
    /**
     * 新单跟进业务ID
     */
    @Schema(description = "新单跟进业务ID")
    private String policyBizId;

    /**
     * 保单产品计划（保单）
     */
    @Schema(description = "保单产品计划（保单）")
    private Policy policy;

    /**
     * 保单投保人
     */
    @Schema(description = "保单投保人")
    private List<PolicyPolicyholder> policyPolicyholderList;

    /**
     * 保单受保人
     */
    @Schema(description = "保单受保人")
    private List<PolicyInsurant> policyInsurantList;

    /**
     * 保单受益人
     */
    @Schema(description = "保单受益人")
    private List<PolicyBeneficiary> policyBeneficiaryList;

    /**
     * 保单第二持有人
     */
    @Schema(description = "保单第二持有人")
    private List<PolicySecondHolder> policySecondHolderList;

    // todo 健康问卷
//    private Object policyholderInfo;

    // 错误信息（如果有查询失败的情况）
    private String errorMessage;

    private static final long serialVersionUID = 1L;
}