package com.yd.csf.feign.request.ruleItemconfig;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiRuleItemConfigAddRequest {

    /**
     * 基本法配置表唯一业务ID
     */
    @NotBlank(message = "基本法配置表唯一业务ID不能为空")
    private String ruleBizId;

    /**
     * 基本法项目名称
     */
    @NotBlank(message = "基本法项目名称不能为空")
    private String itemName;

    /**
     * 计算时间点（字典）
     */
    @NotBlank(message = "计算时间点不能为空")
    private String calculate;

    /**
     * 执行顺序，数值越小越先执行，用于控制佣金项目的计算顺序
     */
    private Integer executionOrder;

    /**
     * 公式配置表唯一业务ID
     */
    private String formulaBizId;

    /**
     * 项目描述
     */
    private String description;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

//    /**
//     * 所属租户唯一业务ID（冗余）
//     */
//    private String tenantBizId;
//
//    /**
//     * 所属项目唯一业务ID（冗余）
//     */
//    private String projectBizId;

}
