package com.yd.csf.api.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yd.common.enums.CommonEnum;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.enums.CommissionStatusEnum;
import com.yd.csf.service.enums.FortuneStatusEnum;
import com.yd.csf.service.model.Commission;
import com.yd.csf.service.model.Fortune;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneImportDTO {
    @ExcelProperty("发佣数据业务id")
    private String fortuneBizId;

    @ExcelProperty("保单号")
    private String policyNo;

    @ExcelProperty("发佣期数")
    private Integer fortunePeriod;

    @ExcelProperty("总发佣期数")
    private Integer fortuneTotalPeriod;

    @ExcelProperty("发佣项目")
    private String fortuneName;

    @ExcelProperty("发佣金额")
    private BigDecimal amount;

    @ExcelProperty("发佣币种")
    private String currency;

    @ExcelProperty("转介人")
    private String broker;

    @ExcelProperty("所属团队")
    private String team;

    @ExcelProperty("备注")
    private String remark;

    /**
     * 转换为 entity
     */
    public static Fortune convertToEntity(FortuneImportDTO data, String loginUserId) {
        Fortune entity = new Fortune();
        // 字段映射
        entity.setPolicyNo(data.getPolicyNo());
        entity.setFortuneBizId(data.getFortuneBizId());
        entity.setFortunePeriod(data.getFortunePeriod());
        entity.setFortuneTotalPeriod(data.getFortuneTotalPeriod());
        entity.setFortuneName(data.getFortuneName());
        entity.setAmount(data.getAmount());
        entity.setCurrency(data.getCurrency());
        entity.setBroker(data.getBroker());
        entity.setTeam(data.getTeam());
        entity.setRemark(data.getRemark());
        entity.setStatus(FortuneStatusEnum.WAIT.getItemValue());
        entity.setCreatorId(loginUserId);
        entity.setUpdaterId(loginUserId);
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        return entity;
    }
}
