package com.yd.csf.feign.dto.excel;

import com.yd.common.enums.DictTypeEnum;
import com.yd.common.utils.DateUtil;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 第二持有人资料
 */
@Data
public class ApiExcelSecondHolderDto {

    //============以下是表字段============
    /**
     * 中文姓名（第二持有人信息表：名字）
     */
    private String name;

    /**
     * 英文姓名(同护照)（第二持有人信息表：名字-英文）
     */
    private String nameEn;

    /**
     * 出生日期（第二持有人信息表：出生日期）
     */
    private LocalDateTime birthTime;

    /**
     * 身份证号码（第二持有人信息表：证件号码）
     */
    private String idNumber;

    /**
     * 性別（第二持有人信息表：性别）
     */
    private String gender;

    /**
     * 與受保人關係（第二持有人信息表：与受保人关系（字典））
     */
    private String insurantRel;

    //============以下是excel显示的字段，同上============

    /**
     * 中文姓名（第二持有人信息表：名字）
     */
    private String secondHolderName;

    /**
     * 英文姓名(同护照)（第二持有人信息表：名字-英文）
     */
    private String secondHolderNameEn;

    /**
     * 出生日期（第二持有人信息表：出生日期）
     */
    private String secondHolderBirthTime;

    /**
     * 身份证号码（第二持有人信息表：证件号码）
     */
    private String secondHolderIdNumber;

    /**
     * 性別（第二持有人信息表：性别）
     */
    private String secondHolderGender;

    /**
     * 與受保人關係（第二持有人信息表：与受保人关系（字典））
     */
    private String secondHolderInsurantRel;

    /**
     * 重新赋值ApiExcelSecondHolderDto
     * @param dto
     * @return
     */
    public static ApiExcelSecondHolderDto setApiExcelSecondHolderDto(ApiExcelSecondHolderDto dto,
                                                                     List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        ApiExcelSecondHolderDto secondHolderDto = new ApiExcelSecondHolderDto();
        BeanUtils.copyProperties(dto,secondHolderDto);
        secondHolderDto.setSecondHolderBirthTime(DateUtil.getyyyyMMdd(dto.getBirthTime()));
        //性別（第二持有人信息表：性别）字典
        secondHolderDto.setSecondHolderGender(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.SYS_GENDER.getItemValue(),dto.getGender()));
        secondHolderDto.setSecondHolderIdNumber(dto.getIdNumber());
        //與受保人關係（第二持有人信息表：与受保人关系（字典））
        secondHolderDto.setSecondHolderInsurantRel(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_AP_REL.getItemValue(),dto.getInsurantRel()));
        secondHolderDto.setSecondHolderName(dto.getName());
        secondHolderDto.setSecondHolderNameEn(dto.getNameEn());
        return secondHolderDto;
    }
}
