package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 预约-签单员信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Getter
@Setter
@TableName("appointment_user_sign")
public class AppointmentUserSign implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约-签单员信息表唯一业务ID
     */
    @TableField("appointment_user_sign_biz_id")
    private String appointmentUserSignBizId;

    /**
     * 预约信息主表唯一业务ID（关联）
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 签单用户扩展唯一业务ID（冗余）
     */
    @TableField("user_sign_biz_id")
    private String userSignBizId;

    /**
     * 系统用户唯一业务ID（冗余）
     */
    @TableField("user_biz_id")
    private String userBizId;

    /**
     * 姓名
     */
    @TableField("real_name")
    private String realName;

    /**
     * 执业编码
     */
    @TableField("practice_code")
    private String practiceCode;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 证件类型
     */
    @TableField("card_type")
    private String cardType;

    /**
     * 证件号码
     */
    @TableField("card_no")
    private String cardNo;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
