package com.yd.csf.service.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.service.model.ExpectedFortune;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yd.csf.service.vo.ExpectedFortuneStatisticsVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 预计发佣表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-11-17
 */
public interface ExpectedFortuneMapper extends BaseMapper<ExpectedFortune> {

    IPage<ApiExpectedFortunePageResponse> page(@Param("page") Page<ApiExpectedFortunePageResponse> page,
                                               @Param("request") ApiExpectedFortunePageRequest request);

    List<ExpectedFortune> listByPolicyBizId(@Param("policyBizId") String policyBizId);

    ExpectedFortuneStatisticsVO getStatistics(@Param("expectedFortuneIds") List<Long> expectedFortuneIds);
}
