package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.PremiumRemittanceDto;
import com.yd.csf.service.model.PremiumRemittance;
import com.yd.csf.service.dao.PremiumRemittanceMapper;
import com.yd.csf.service.service.IPremiumRemittanceService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 保费汇款记录表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-26
 */
@Service
public class PremiumRemittanceServiceImpl extends ServiceImpl<PremiumRemittanceMapper, PremiumRemittance> implements IPremiumRemittanceService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<PremiumRemittance> queryList(PremiumRemittanceDto dto) {
        List<PremiumRemittance> list = baseMapper.selectList(new LambdaQueryWrapper<PremiumRemittance>()
                .eq(StringUtils.isNotBlank(dto.getPremiumReconciliationBizId()),PremiumRemittance::getPremiumReconciliationBizId,dto.getPremiumReconciliationBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param premiumRemittanceBizId
     * @return
     */
    @Override
    public PremiumRemittance queryOne(String premiumRemittanceBizId) {
        return this.getOne(new LambdaQueryWrapper<PremiumRemittance>()
                .eq(PremiumRemittance::getPremiumRemittanceBizId,premiumRemittanceBizId).last(" limit 1 "));
    }

    /**
     * 根据保费对账-汇款记录表唯一业务ID删除
     * @param premiumRemittanceBizId
     * @return
     */
    @Override
    public Boolean delByPremiumRemittanceBizId(String premiumRemittanceBizId) {
        return this.remove(new LambdaQueryWrapper<PremiumRemittance>().eq(PremiumRemittance::getPremiumRemittanceBizId,premiumRemittanceBizId));
    }

}
