package com.yd.csf.feign.client.expectedfortunelog;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.expectedfortunelog.ApiExpectedFortuneLogFeignFallbackFactory;
import com.yd.csf.feign.request.expectedfortunelog.ApiExpectedFortuneLogPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 香港保险服务-预计发佣日志记录信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiExpectedFortuneLogFeignFallbackFactory.class)
public interface ApiExpectedFortuneLogFeignClient {

    /**
     * 分页查询 - 生成预计发佣日志记录
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiExpectedFortuneLogPageRequest request);
}
