package com.yd.csf.feign.dto.appointment;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 第二持有人信息
 */
@Data
public class ApiSecondHolderInfoDto {

    /**
     * 第二持有人信息表主键id（新增不需要传值，修改需要传值）
     */
    private Long id;

    /**
     * 预约信息主表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String appointmentBizId;

    /**
     * 第二持有人信息表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String secondHolderBizId;

    /**
     * 与受保人关系（字典）
     */
    private String insurantRel;

    /**
     * 名字
     */
    private String name;

    /**
     * 名字-英文
     */
    private String nameEn;

    /**
     * 性别（字典）
     */
    private String gender;

    /**
     * 证件类型（字典）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 护照号码
     */
    private String passportNumber;

    /**
     * 出生日期
     */
    private LocalDateTime birthTime;

    /**
     * 年龄
     */
    private String age;
}
