package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 查询commission请求
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CommissionQueryRequest extends PageDto implements Serializable {
    /**
     * 预计入账 id
     */
    @Schema(description = "预计入账 id")
    private String commissionExpectedBizId;

    /**
     * 检核年月
     */
    @Schema(description = "检核年月 格式: yyyy-MM")
    private String reconciliationYearMonth;

    /**
     * 比对状态
     */
    @Schema(description = "比对状态 '0'-'未比对','1'-'比对成功','2'-'比对失败', 字典值: csf_commission_status")
    private List<String> statusList;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 对账公司业务id列表
     */
    @Schema(description = "对账公司业务id列表")
    private List<String> reconciliationCompanyBizIdList;

    /**
     * 保险公司业务id列表
     */
    @Schema(description = "保险公司业务id列表")
    private List<String> insuranceCompanyBizIdList;

    /**
     * 来佣日期开始
     */
    @Schema(description = "来佣日期开始", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDateStart;

    /**
     * 来佣日期结束
     */
    @Schema(description = "来佣日期结束", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDateEnd;

    /**
     * 预计入账日期
     */
    @Schema(description = "预计入账日期 格式-yyyy-MM-dd", example = "2023-01-01")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expectedDate;

    private static final long serialVersionUID = 1L;
}