package com.yd.csf.feign.fallback.variable;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.variable.ApiVariableFeignClient;
import com.yd.csf.feign.request.variable.ApiVariableAddRequest;
import com.yd.csf.feign.request.variable.ApiVariableEditRequest;
import com.yd.csf.feign.request.variable.ApiVariablePageRequest;
import com.yd.csf.feign.response.variable.ApiVariableDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-变量信息Feign降级处理
 */
@Slf4j
@Component
public class ApiVariableFeignFallbackFactory implements FallbackFactory<ApiVariableFeignClient> {
    @Override
    public ApiVariableFeignClient create(Throwable cause) {
        return new ApiVariableFeignClient() {
            @Override
            public Result page(ApiVariablePageRequest request) {
                return null;
            }

            @Override
            public Result<ApiVariableDetailResponse> detail(String variableBizId) {
                return null;
            }

            @Override
            public Result add(ApiVariableAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiVariableEditRequest request) {
                return null;
            }

            @Override
            public Result del(String variableBizId) {
                return null;
            }
        };
    }
}
