package com.yd.csf.feign.dto.excel;

import com.yd.common.enums.DictTypeEnum;
import com.yd.common.utils.DateUtil;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 受益人资料
 */
@Data
public class ApiExcelBeneficiaryDto {

    //============以下是表字段============
    /**
     * 中文姓名（受益人信息表：名字）
     */
    private String name;

    /**
     * 英文姓名 (同护照)（受益人信息表：名字-英文）
     */
    private String nameEn;

    /**
     * 出生日期 (西元 年/月/日)（受益人信息表：出生日期）
     */
    private LocalDateTime birthTime;

    /**
     * 身份证号码（受益人信息表：证件号码）
     */
    private String idNumber;

    /**
     * 與受保人關係（受益人信息表：与受保人关系（字典））
     */
    private String insurantRel;

    /**
     * 受益比例 (%)（受益人信息表：受益比例）
     */
    private BigDecimal benefitRatio;


    //============以下是excel显示的字段，同上============
    /**
     * 中文姓名（受益人信息表：名字）
     */
    private String beneficiaryName;

    /**
     * 英文姓名 (同护照)（受益人信息表：名字-英文）
     */
    private String beneficiaryNameEn;

    /**
     * 出生日期 (西元 年/月/日)（受益人信息表：出生日期）
     */
    private String beneficiaryBirthTime;

    /**
     * 身份证号码（受益人信息表：证件号码）
     */
    private String beneficiaryIdNumber;

    /**
     * 與受保人關係（受益人信息表：与受保人关系（字典））
     */
    private String beneficiaryInsurantRel;

    /**
     * 受益比例 (%)（受益人信息表：受益比例）
     */
    private BigDecimal beneficiaryBenefitRatio;


    /**
     * 重新赋值ApiExcelBeneficiaryDto
     * @param list
     * @return
     */
    public static List<ApiExcelBeneficiaryDto> setApiExcelBeneficiaryDtoList(List<ApiExcelBeneficiaryDto> list,
                                                                             List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        List<ApiExcelBeneficiaryDto> newList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            newList = list.stream().map(dto -> {
                ApiExcelBeneficiaryDto newDto = new ApiExcelBeneficiaryDto();
                BeanUtils.copyProperties(dto,newDto);
                newDto.setBeneficiaryBenefitRatio(dto.getBeneficiaryBenefitRatio());
                newDto.setBeneficiaryBirthTime(DateUtil.getyyyyMMdd(dto.getBirthTime()));
                newDto.setBeneficiaryIdNumber(newDto.getIdNumber());
                //與受保人關係（受益人信息表：与受保人关系（字典））
                newDto.setBeneficiaryInsurantRel(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                        DictTypeEnum.CSF_AP_REL.getItemValue(),newDto.getInsurantRel()));
                newDto.setBeneficiaryName(newDto.getName());
                newDto.setBeneficiaryNameEn(newDto.getNameEn());
                return newDto;
            }).collect(Collectors.toList());
        }
        return newList;
    }
}
