package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiAgentReferralRelationService;
import com.yd.csf.feign.client.agentreferralrelation.ApiAgentReferralRelationFeignClient;
import com.yd.csf.feign.request.agentreferralrelation.ApiAgentReferralRelationSaveRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 推荐关系信息
 *
 * @author zxm
 * @since 2025-10-15
 */
@RestController
@RequestMapping("/agentReferralRelation")
@Validated
public class ApiAgentReferralRelationController implements ApiAgentReferralRelationFeignClient {

    @Autowired
    private ApiAgentReferralRelationService apiAgentReferralRelationService;

    /**
     * 保存-推荐关系信息
     * @param request
     * @return
     */
    @Override
    public Result save(ApiAgentReferralRelationSaveRequest request) {
        return apiAgentReferralRelationService.save(request);
    }

}
