package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneAccountAddRequest implements Serializable {
    /**
     * 转介人
     */
    @Schema(description = "转介人", requiredMode = Schema.RequiredMode.REQUIRED)
    private String broker;

    /**
     * 所属团队
     */
    @Schema(description = "所属团队", requiredMode = Schema.RequiredMode.REQUIRED)
    private String team;

    /**
     * 出账币种
     */
    @Schema(description = "出账币种", requiredMode = Schema.RequiredMode.REQUIRED)
    private String currency;

    /**
     * 出账总额
     */
    @Schema(description = "出账总额", requiredMode = Schema.RequiredMode.REQUIRED)
    private BigDecimal amount;

    /**
     * 出账状态 0-可出账、1-待出账、2-已出账
     */
    @Schema(description = "出账状态 0-可出账、1-待出账、2-已出账", requiredMode = Schema.RequiredMode.REQUIRED)
    private String status;

    /**
     * 出账日期
     */
    @Schema(description = "出账日期", requiredMode = Schema.RequiredMode.REQUIRED, example = "2025-09-19", format = "date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date fortuneAccountDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
