package com.yd.csf.feign.client.policyreceipt;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.policyreceipt.ApiPolicyReceiptFeignFallbackFactory;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptAddRequest;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptPageRequest;
import com.yd.csf.feign.response.policyreceipt.ApiPolicyReceiptDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-保单回执信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiPolicyReceiptFeignFallbackFactory.class)
public interface ApiPolicyReceiptFeignClient {

    /**
     * 分页列表查询-保单回执信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiPolicyReceiptPageRequest request);

    /**
     * 详情-保单回执信息
     * @param policyReceiptBizId 保单回执表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiPolicyReceiptDetailResponse> detail(@NotBlank(message = "保单回执表唯一业务ID能为空") @RequestParam(value = "policyReceiptBizId") String policyReceiptBizId);

    /**
     * 添加-保单回执信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiPolicyReceiptAddRequest request);

    /**
     * 编辑-回执状态
     * @param policyReceiptBizId 保单回执信息表唯一标识(业务ID)
     * @param receiptStatus 回执状态（CONFIRMED-已确认 UNCONFIRMED-未确认）
     * @return
     */
    @PutMapping("/edit/receiptStatus")
    Result editReceiptStatus(@NotBlank(message = "保单回执信息表唯一业务ID能为空") @RequestParam(value = "policyReceiptBizId") String policyReceiptBizId,
                             @NotBlank(message = "回执状态不能为空") @RequestParam(value = "receiptStatus") String receiptStatus);
}
