package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiExpectedFortuneService;
import com.yd.csf.feign.client.expectedfortune.ApiExpectedFortuneFeignClient;
import com.yd.csf.feign.request.expectedfortune.ApiGenerateExpectedFortuneRequest;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.feign.response.expectedfortune.ApiGenerateExpectedFortuneResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预计发佣信息
 *
 * @author zxm
 * @since 2025-11-17
 */
@RestController
@RequestMapping("/expectedFortune")
@Validated
public class ApiExpectedFortuneController implements ApiExpectedFortuneFeignClient {

    @Autowired
    private ApiExpectedFortuneService apiExpectedFortuneService;

    /**
     * 生成预计发佣
     * @param request
     * @return
     */
    @Override
    public Result<ApiGenerateExpectedFortuneResponse> generate(ApiGenerateExpectedFortuneRequest request) {
        return apiExpectedFortuneService.generate(request);
    }

    /**
     * 分页查询 - 预计发佣
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedFortunePageResponse>> page(ApiExpectedFortunePageRequest request) {
        return apiExpectedFortuneService.page(request);
    }
}
