package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 查询customer请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PolicyFollowQueryRequest extends PageDto implements Serializable {

    /**
     * 新单状态
     */
    @Schema(description = "新单状态 'CHECKING'-'审核中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消', 字典值: csf_policy_follow_status")
    private String status;

    /**
     * 新单编号
     */
    @Schema(description = "新单编号")
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String customerName;

    /**
     * 客户编号
     */
    @Schema(description = "客户编号")
    private String customerBizId;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insurer;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;


    private static final long serialVersionUID = 1L;
}