package com.yd.csf.service.enums;

/**
 * fna状态枚举 'DRAFT'-草稿, 'UNCOMPLETED'-未完成, 'COMPLETED'-已完成
 */
public enum FnaStatusEnum {
    DRAFT("草稿", "DRAFT"),
    UNCOMPLETED("未完成", "UNCOMPLETED"),
    COMPLETED("已完成", "COMPLETED"),
    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    FnaStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
