package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigPageRequest;
import com.yd.csf.feign.response.commissionruleconfig.ApiCommissionRuleConfigPageResponse;
import com.yd.csf.service.dto.CommissionRuleConfigDto;
import com.yd.csf.service.model.CommissionRuleConfig;
import com.yd.csf.service.dao.CommissionRuleConfigMapper;
import com.yd.csf.service.service.ICommissionRuleConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 基本法配置表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class CommissionRuleConfigServiceImpl extends ServiceImpl<CommissionRuleConfigMapper, CommissionRuleConfig> implements ICommissionRuleConfigService {

    @Override
    public IPage<ApiCommissionRuleConfigPageResponse> page(Page<ApiCommissionRuleConfigPageResponse> page,
                                                           ApiCommissionRuleConfigPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<CommissionRuleConfig> queryList(CommissionRuleConfigDto dto) {
        List<CommissionRuleConfig> list = baseMapper.selectList(new LambdaQueryWrapper<CommissionRuleConfig>()
                .eq(StringUtils.isNotBlank(dto.getRuleBizId()) && !dto.getIsExcludeMy(),CommissionRuleConfig::getRuleBizId,dto.getRuleBizId())
                .eq(StringUtils.isNotBlank(dto.getRuleName()),CommissionRuleConfig::getRuleName,dto.getRuleName())
                .ne(dto.getIsExcludeMy(),CommissionRuleConfig::getRuleBizId,dto.getRuleBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param ruleBizId
     * @return
     */
    @Override
    public CommissionRuleConfig queryOne(String ruleBizId) {
        return this.getOne(new LambdaQueryWrapper<CommissionRuleConfig>().eq(CommissionRuleConfig::getRuleBizId,ruleBizId));
    }

}
